package com.atlassian.bitbucket.event.repository;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Raised when an attempt to create a repository fails.
 * <p>
 * If repository creation was {@link RepositoryCreationRequestedEvent#isCanceled() canceled}, this event will
 * <i>not</i> be raised, as creation did not fail--it was never attempted.
 */
@AsynchronousPreferred
public class RepositoryCreationFailedEvent extends RepositoryEvent {

    public RepositoryCreationFailedEvent(@Nonnull Object source, @Nonnull Repository repository) {
        super(source, repository);
    }
}
