package com.atlassian.bitbucket.event.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Event that is raised when you finish a review on a pull request.
 *
 * @since 7.7
 */
@AsynchronousPreferred
@EventName("stash.pullrequest.review.finished")
public class PullRequestReviewFinishedEvent extends PullRequestReviewEvent {

    private final boolean addedComment;
    private final int commentCount;
    private final PullRequestParticipantStatus participantStatus;

    /**
     * @param source            the component raising the event
     * @param commentCount      the number of pending comments that got published
     * @param pullRequest       the affected pull request
     * @param addedComment      whether or not a general comment was added upon finishing the review
     * @param participantStatus the reviewer's status change on the pull request
     */
    public PullRequestReviewFinishedEvent(@Nonnull Object source, int commentCount, @Nonnull PullRequest pullRequest,
                                          boolean addedComment, @Nullable PullRequestParticipantStatus participantStatus) {
        super(source, pullRequest, PullRequestAction.REVIEW_FINISHED);

        this.addedComment = addedComment;
        this.commentCount = commentCount;
        this.participantStatus = participantStatus;
    }

    @Nullable
    public PullRequestParticipantStatus getParticipantStatus() {
        return participantStatus;
    }

    public int getCommentCount() {
        return commentCount;
    }

    public boolean isAddedComment() {
        return addedComment;
    }
}
