package com.atlassian.bitbucket.event.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event that is raised when you discard a review on a pull request.
 *
 * @since 7.7
 */
@AsynchronousPreferred
@EventName("stash.pullrequest.review.discarded")
public class PullRequestReviewDiscardedEvent extends PullRequestReviewEvent {

    /**
     * @param source       the component raising the event
     * @param pullRequest  the affected pull request
     */
    public PullRequestReviewDiscardedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest) {
        super(source, pullRequest, PullRequestAction.REVIEW_DISCARDED);
    }
}
