package com.atlassian.bitbucket.event.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Event that is raised when a pull request is reopened.
 */
@AsynchronousPreferred
@EventName("stash.pullrequest.reopened")
public class PullRequestReopenedEvent extends PullRequestEvent {

    private final String previousFromHash;
    private final String previousToHash;

    public PullRequestReopenedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest,
                                    @Nonnull String previousFromHash, @Nonnull String previousToHash) {
        super(source, pullRequest, PullRequestAction.REOPENED);

        this.previousFromHash = requireNonNull(previousFromHash, "previousFromHash");
        this.previousToHash = requireNonNull(previousToHash, "previousToHash");
    }

    @Nonnull
    public String getPreviousFromHash() {
        return previousFromHash;
    }

    @Nonnull
    public String getPreviousToHash() {
        return previousToHash;
    }
}
