package com.atlassian.bitbucket.event.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event raised when a {@link PullRequestParticipant participant} updates its status
 * on a {@link PullRequest pull request} to {@link PullRequestParticipantStatus#NEEDS_WORK}
 * @since 4.4
 */
@AsynchronousPreferred
@EventName("stash.pullrequest.reviewed")
public class PullRequestParticipantReviewedEvent extends PullRequestParticipantStatusUpdatedEvent {

    public PullRequestParticipantReviewedEvent(@Nonnull Object source,
                                               @Nonnull PullRequest pullRequest,
                                               @Nonnull PullRequestParticipant participant,
                                               @Nonnull PullRequestParticipantStatus previous) {
        super(source, pullRequest, getAction(participant), participant, previous);
    }

    private static PullRequestAction getAction(PullRequestParticipant participant) {
        return participant.getStatus() == PullRequestParticipantStatus.NEEDS_WORK
               ? PullRequestAction.REVIEWED : PullRequestAction.APPROVED;
    }
}
