package com.atlassian.bitbucket.event.pull;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.event.CancelableEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.util.CancelState;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Event that is raised before a comment in a pull request is deleted. This event is synchronous, allowing
 * listeners to perform operations in the same database transaction where the comment is deleted.
 * <p>
 * This event is also {@link CancelableEvent cancelable}. A listener may prevent the comment from being deleted by
 * {@link #cancel(KeyedMessage) canceling} this event. Throwing an exception <i>will not</i> prevent the comment from
 * being deleted; the exception will be logged and ignored.
 *
 * @since 6.6
 */
public class PullRequestCommentDeletionRequestedEvent extends PullRequestCancelableCommentEvent {

    public PullRequestCommentDeletionRequestedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest,
                                                    @Nonnull Comment comment, @Nullable Comment parent,
                                                    @Nonnull CancelState cancelState) {
        super(source, pullRequest, comment, parent, CommentAction.DELETED, cancelState);
    }
}
