package com.atlassian.bitbucket.event.pull;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.event.CancelableEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.util.CancelState;

import javax.annotation.Nonnull;

/**
 * Event that is raised before a comment is added to a pull request. This event is synchronous, allowing
 * listeners to perform operations in the same database transaction where the comment is added.
 * <p>
 * This event is also {@link CancelableEvent cancelable}. A listener may prevent the comment from being added by
 * {@link #cancel(KeyedMessage) canceling} this event. Throwing an exception <i>will not</i> prevent the comment from
 * being added; the exception will be logged and ignored.
 * <p>
 * This does not include replies, which raise a {@link PullRequestCommentReplyRequestedEvent}.
 *
 * @since 6.6
 */
public class PullRequestCommentAddRequestedEvent extends PullRequestCancelableCommentEvent {

    public PullRequestCommentAddRequestedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest,
                                               @Nonnull Comment comment, @Nonnull CancelState cancelState) {
        super(source, pullRequest, comment, null, CommentAction.ADDED, cancelState);
    }
}
