package com.atlassian.bitbucket.event.pull;

import com.atlassian.bitbucket.pull.PullRequestCommentActivity;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event that is raised when a comment activity is created for a pull request.
 */
@AsynchronousPreferred
public class PullRequestCommentActivityEvent extends PullRequestActivityEvent {

    public PullRequestCommentActivityEvent(@Nonnull Object source, @Nonnull PullRequestCommentActivity activity) {
        super(source, activity);
    }

    @Nonnull
    @Override
    public PullRequestCommentActivity getActivity() {
        return (PullRequestCommentActivity) super.getActivity();
    }
}
