package com.atlassian.bitbucket.event.project;

import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.project.Project;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Base class for all project related events.
 * <p>
 * This event is internally audited at the {@link CoverageLevel#BASE} level.
 */
public abstract class ProjectEvent extends ApplicationEvent {

    private final Project project;

    protected ProjectEvent(@Nonnull Object source, @Nonnull Project project) {
        super(source);

        this.project = requireNonNull(project, "project");
    }

    @Nonnull
    public Project getProject() {
        return this.project;
    }
}
