package com.atlassian.bitbucket.event.permission;

import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.user.ApplicationUser;

/**
 * This event is fired when a user, group or all licensed users have their permission modified for a given project.
 * <p>
 * This event is internally audited with {@link CoverageLevel#BASE} level.
 */
public class ProjectPermissionModifiedEvent extends AbstractProjectPermissionModificationEvent implements PermissionModifiedEvent {

    public ProjectPermissionModifiedEvent(Object source, Permission oldValue, Permission newValue, Project project,
                                          String affectedGroup, ApplicationUser affectedUser) {
        super(source, oldValue, newValue, project, affectedGroup, affectedUser);
    }

}
