package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * An event which is fired when a user or group is granted a permission.
 *
 * @see GlobalPermissionGrantedEvent
 * @see ProjectPermissionGrantedEvent
 * @see RepositoryPermissionGrantedEvent
 */
public interface PermissionGrantedEvent {

    /**
     * @return the affected group of {@code null} if a user was affected
     */
    @Nullable
    String getAffectedGroup();

    /**
     * @return the affected user of {@code null} if a group was affected
     */
    @Nullable
    ApplicationUser getAffectedUser();

    /**
     * @return the permission granted
     */
    @Nonnull
    Permission getPermission();
}
