package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkArgument;
import static java.util.Objects.requireNonNull;

/**
 * @see ProjectPermissionModificationRequestedEvent
 * @see ProjectPermissionModifiedEvent
 */
public abstract class AbstractProjectPermissionModificationEvent extends ProjectPermissionEvent {

    private final Permission oldValue;

    protected AbstractProjectPermissionModificationEvent(Object source,
                                                         Permission oldValue, Permission newValue,
                                                         Project project,
                                                         String affectedGroup, ApplicationUser affectedUser) {
        super(source, newValue, project, affectedGroup, affectedUser);

        this.oldValue = requireNonNull(oldValue, "oldValue");
        checkArgument(oldValue.isResource(Project.class) && oldValue.isGrantable(), "oldValue must be a grantable project permission");
    }

    @Nonnull
    public Permission getNewValue() {
        return getPermission();
    }

    @Nonnull
    public Permission getOldValue() {
        return oldValue;
    }
}
