package com.atlassian.bitbucket.event.mirror;

import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;

/**
 * This event signals that a {@link Repository} has failed to synchronize on a mirror.
 *
 * @since 5.0
 */
public class RepositoryMirrorSynchronizationFailedEvent extends AbstractRepositoryMirrorEvent {

    private RepositoryMirrorSynchronizationFailedEvent(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractRepositoryMirrorEvent.Builder<Builder, RepositoryMirrorSynchronizationFailedEvent> {

        @Nonnull
        @Override
        public RepositoryMirrorSynchronizationFailedEvent build() {
            super.validate();
            return new RepositoryMirrorSynchronizationFailedEvent(this);
        }
    }
}