package com.atlassian.bitbucket.event.migration;

import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Raised when database migration completes successfully. When this event is raised, the system is running on
 * the new database.
 * <p>
 * This event is internally audited with {@link CoverageLevel#BASE} level.
 */
@AsynchronousPreferred
public class MigrationSucceededEvent extends MigrationEndedEvent {

    public MigrationSucceededEvent(@Nonnull Object source) {
        super(source);
    }
}
