package com.atlassian.bitbucket.event.migration;

import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Raised when database migration is canceled.
 * <p>
 * This event is internally audited with {@link CoverageLevel#BASE} level.
 */
@AsynchronousPreferred
public class MigrationCanceledEvent extends MigrationEndedEvent {

    public MigrationCanceledEvent(@Nonnull Object source) {
        super(source);
    }
}
