package com.atlassian.bitbucket.event.maintenance;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Fired when maintenance has ended. Plugins may resume using database connections and other resources at this point.
 */
@AsynchronousPreferred
@EventName("stash.maintenance.ended")
public class MaintenanceEndedEvent extends MaintenanceEvent {

    public MaintenanceEndedEvent(@Nonnull Object source) {
        super(source);
    }
}
