package com.atlassian.bitbucket.event.commit;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.event.CancelableEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.util.CancelState;

import javax.annotation.Nonnull;

/**
 * Event that is raised before a comment is added to a commit discussion. This event is synchronous, allowing
 * listeners to perform operations in the same database transaction where the comment is added.
 * <p>
 * This event is also {@link CancelableEvent cancelable}. A listener may prevent the comment from being added by
 * {@link #cancel(KeyedMessage) canceling} this event. Throwing an exception <i>will not</i> prevent the comment from
 * being added; the exception will be logged and ignored.
 * <p>
 * This does not include replies, which raise a {@link CommitDiscussionCommentReplyRequestedEvent}.
 *
 * @since 6.6
 */
public class CommitDiscussionCommentAddRequestedEvent extends CommitDiscussionCancelableCommentEvent {

    public CommitDiscussionCommentAddRequestedEvent(@Nonnull Object source, @Nonnull CommitDiscussion discussion,
                                                    @Nonnull Comment comment, @Nonnull CancelState cancelState) {
        super(source, discussion, comment, null, CommentAction.ADDED, cancelState);
    }
}
