package com.atlassian.bitbucket.event.commit;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.event.CancelableEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.util.CancelState;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static java.util.Objects.requireNonNull;

/**
 * Subclasses of this event are synchronous and allow callers to cancel the action and/or participate in the
 * transaction (by persisting related entities, for example).
 *
 * @since 6.6
 */
@TransactionAware(TransactionAware.When.IMMEDIATE) //Override CommitDiscussionEvent's annotation so we're synchronous
public abstract class CommitDiscussionCancelableCommentEvent extends CommitDiscussionCommentEvent
        implements CancelableEvent {

    private final CancelState cancelState;

    protected CommitDiscussionCancelableCommentEvent(@Nonnull Object source, @Nonnull CommitDiscussion discussion,
                                                     @Nonnull Comment comment, @Nullable Comment parent,
                                                     @Nonnull CommentAction commentAction,
                                                     @Nonnull CancelState cancelState) {
        super(source, discussion, comment, parent, commentAction);

        this.cancelState = requireNonNull(cancelState, "cancelState");
    }

    @Override
    public void cancel(@Nonnull KeyedMessage message) {
        cancelState.cancel(message);
    }

    @Override
    public boolean isCanceled() {
        return cancelState.isCanceled();
    }
}
