package com.atlassian.bitbucket.event.auth;

import com.atlassian.bitbucket.event.ApplicationEvent;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Base class for constructing events that relate to authentication.
 */
public abstract class AbstractAuthenticationEvent extends ApplicationEvent {

    private final String authenticationMethod;
    private final String username;

    protected AbstractAuthenticationEvent(@Nonnull Object source, @Nullable String username, @Nonnull String method) {
        super(source);

        this.authenticationMethod = method;
        this.username = username;
    }

    @Nonnull
    public String getAuthenticationMethod() {
        return authenticationMethod;
    }

    @Nullable
    public String getUsername() {
        return username;
    }
}
