package com.atlassian.bitbucket.event;

import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Date;
import java.util.EventObject;

import static java.util.Objects.requireNonNull;

/**
 * Base event class for all application events.
 */
public abstract class ApplicationEvent extends EventObject {
    
    private final long date;
    private final ApplicationUser user;
    
    protected ApplicationEvent(@Nonnull Object source) {
        super(requireNonNull(source, "source"));

        date = System.currentTimeMillis();
        user = null; // will be set when the event is published
    }

    @Nonnull
    public final Date getDate() {
        return new Date(date);
    }

    @Nullable
    public final ApplicationUser getUser() {
        return user;
    }
}
