package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.util.Page;

import javax.annotation.Nonnull;

/**
 * Represents a revision of a directory
 */
public interface DirectoryRevision {

    /**
     * @return a Page of nodes that are contained in the Directory at the revision.
     */
    @Nonnull
    Page<ContentTreeNode> getChildren();

    /**
     * @return the commit ID of the Directory
     */
    @Nonnull
    String getCommitId();

    /**
     * @return the path of the directory
     */
    @Nonnull
    Path getPath();
}
