package com.atlassian.bitbucket.content;

import org.apache.commons.lang3.StringUtils;

/**
 * A flag for indicating how whitespace should be handled in a diff, such as being {@link #IGNORE_ALL ignored}.
 */
public enum DiffWhitespace {

    /**
     * The default whitespace setting, where the exact changes of the diff are shown, whitespace and all.
     */
    SHOW,

    /**
     * Ignore all whitespace in the diff.
     */
    IGNORE_ALL;

    /**
     * @param value the string value
     * @return a coerced string to a {@link DiffWhitespace} value, or {@link #SHOW}, but never {@code null}.
     */
    public static DiffWhitespace fromString(String value) {
        try {
            return StringUtils.isBlank(value) ? SHOW : valueOf(StringUtils.replace(value.toUpperCase(), "-", "_"));
        } catch (IllegalArgumentException ignored) {
            return SHOW;
        }
    }
}
