package com.atlassian.bitbucket.content;

/**
 * Enumerates the different segment types available in diff output.
 */
public enum DiffSegmentType {

    /**
     * Indicates the lines in the segment were added in the destination file.
     */
    ADDED(0, false, true),
    /**
     * Indicates the lines in the segment are context, existing unchanged in both the source and destination.
     */
    CONTEXT(1, true, true),
    /**
     * Indicates the lines in the segment were removed in the destination file.
     */
    REMOVED(2, true, false);

    private final int id;
    private final boolean inDestination;
    private final boolean inSource;

    DiffSegmentType(int id, boolean inSource, boolean inDestination) {
        this.id = id;
        this.inDestination = inDestination;
        this.inSource = inSource;
    }

    public static DiffSegmentType fromId(int id) {
        for (DiffSegmentType value : values()) {
            if (value.getId() == id) {
                return value;
            }
        }
        throw new IllegalArgumentException("No DiffSegmentType is associated with ID [" + id + "]");
    }

    public int getId() {
        return id;
    }

    public boolean isInDestination() {
        return inDestination;
    }

    public boolean isInSource() {
        return inSource;
    }
}
