package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.util.AbstractPagedSummary;
import com.atlassian.bitbucket.util.AbstractSummary;

import javax.annotation.Nonnull;

public class ContentTreeSummary extends AbstractPagedSummary {

    private ContentTreeSummary(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractPagedBuilder<Builder, ContentTreeSummary> {

        /**
         * Creates and initializes a new builder using details from the provided {@link AbstractSummary summary}. If
         * the provided summary is {@link AbstractPagedSummary paged}, those details will also be copied over.
         *
         * @param summary the summary to initialize this builder from
         */
        public Builder(@Nonnull AbstractSummary summary) {
            super(summary);
        }

        /**
         * Creates a new builder with the provided {@link CommandResult result}.
         *
         * @param result the operation result for the summary
         */
        public Builder(@Nonnull CommandResult result) {
            super(result);
        }

        @Nonnull
        @Override
        public ContentTreeSummary build() {
            return new ContentTreeSummary(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
