package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.util.BuilderSupport;

import javax.annotation.Nonnull;

public class ContentTreeContext {

    private final String commitId;
    private final boolean recursive;

    private ContentTreeContext(Builder builder) {
        commitId = builder.commitId;
        recursive = builder.recursive;
    }

    /**
     * @return the ID of the commit at which the content tree is being streamed
     */
    @Nonnull
    public String getCommitId() {
        return commitId;
    }

    public boolean isRecursive() {
        return recursive;
    }

    public static class Builder extends BuilderSupport {

        private final String commitId;

        private boolean recursive;

        public Builder(@Nonnull String commitId) {
            this.commitId = checkNotBlank(commitId, "commitId");
        }

        @Nonnull
        public ContentTreeContext build() {
            return new ContentTreeContext(this);
        }

        @Nonnull
        public Builder recursive(boolean value) {
            recursive = value;

            return this;
        }
    }
}
