package com.atlassian.bitbucket.content;

import javax.annotation.Nonnull;
import java.io.IOException;

/**
 * Convenience implementation of {@link ChangeCallback} that provides no-op implementations for all methods.
 */
public class AbstractChangeCallback implements ChangeCallback {

    /**
     * Discards the provided {@link Change} and returns {@code true} to continue streaming.
     *
     * @param change ignored
     * @return {@code true}
     * @throws IOException may be thrown by derived classes
     */
    @Override
    public boolean onChange(@Nonnull Change change) throws IOException {
        return true;
    }

    @Override
    public void onEnd(@Nonnull ChangeSummary summary) throws IOException {
    }

    @Override
    public void onStart(@Nonnull ChangeContext context) throws IOException {
    }
}
