package com.atlassian.bitbucket.commit.graph;

import com.atlassian.bitbucket.commit.CommitService;

import javax.annotation.Nonnull;

/**
 * A callback which can be used during
 * a {@link CommitService#traverse(TraversalRequest, TraversalCallback) traverse}
 * of the nodes within a commit graph.
 *
 * @see CommitService#traverse(TraversalRequest, TraversalCallback)
 */
public abstract class TraversalCallback {

    /**
     * Receive a summary of the traversal when it has completed.
     *
     * @param summary summary of the traversal
     */
    public void onEnd(@Nonnull TraversalSummary summary) {
    }

    /**
     * Visit a node in the commit graph. All commits are guaranteed to be visited in topological order:
     * that is children will be visited before parents within the graph.
     *
     * @param node the current node being traversed
     * @return the status of the traversal after visiting the node. If traversal is
     *         {@link TraversalStatus#FINISH complete} this method will not be invoked again.
     */
    public abstract TraversalStatus onNode(@Nonnull CommitGraphNode node);

    public void onStart(@Nonnull TraversalContext context) {
    }
}
