package com.atlassian.bitbucket.commit;

import javax.annotation.Nonnull;

/**
 * A minimal commit, defining only identifier information.
 */
public interface MinimalCommit {

    /**
     * An identifier for this commit suitable for display to end users.
     * <p>
     * No guarantees are made as to how this identifier differs from {@link #getId()}--they may be identical or not, at
     * the whim of the underlying SCM implementation. In practice, however, the returned identifier should be sensible
     * for users familiar with the underlying SCM.
     *
     * @return a display ID
     */
    @Nonnull
    String getDisplayId();

    /**
     * An identifier for this commit which may be passed to the system in order to retrieve more information related
     * to it.
     *
     * @return a commit ID
     */
    @Nonnull
    String getId();
}
