package com.atlassian.bitbucket.commit;

/**
 * @since 5.0
 */
public enum CommitOrder {

    /**
     * Traverse commits in reverse date order, which is <strong>not</strong> guaranteed to be in topological order;
     * parents may be shown before their descendant commits if the descendant commit predates the parent commit.
     */
    DATE,
    /**
     * Uses the default ordering of the underlying SCM
     */
    DEFAULT,
    /**
     * Traverse the commits in topological order (i.e. descendant commits are shown before their parents).
     */
    TOPOLOGICAL
}
