package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.ChangesRequest;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Describes a set of changes between two commits. If this class is used to describe the changes that have been made in
 * a simple commit with a single parent, {@code fromCommit} refers to the parent commit, while {@code toCommit} refers
 * to the commit itself. This class can also be used to describe the changes between arbitrary commits.
 */
public interface Changeset {

    /**
     * Retrieves the first {@link Page page} of {@link Change changes} for this changeset. If it is not the
     * {@link Page#getIsLastPage() last page}, more changes can be retrieved using:
     * <ul>
     *     <li>{@link CommitService#getChanges(ChangesRequest, PageRequest)}</li>
     *     <li>{@link CommitService#streamChanges(ChangesRequest, ChangeCallback)}</li>
     * </ul>
     *
     * @return the first page of changes
     */
    @Nullable
    Page<Change> getChanges();

    /**
     * @return the 'from' commit
     */
    @Nullable
    MinimalCommit getFromCommit();

    /**
     * @return the 'to' commit
     */
    @Nonnull
    Commit getToCommit();
}
