package com.atlassian.bitbucket.comment;

/**
 * Enumerates the different actions which may be taken on a comment.
 */
public enum CommentAction {

    /**
     * A new {@link Comment} has been added.
     */
    ADDED(0),
    /**
     * A {@link Comment} has been deleted.
     */
    DELETED(1),
    /**
     * A {@link Comment} has been edited.
     */
    EDITED(2),
    /**
     * A {@link Comment} has been replied to.
     */
    REPLIED(3);

    private final int id;

    private CommentAction(int id) {
        this.id = id;
    }

    public static CommentAction fromId(int id) {
        for (CommentAction value : values()) {
            if (value.getId() == id) {
                return value;
            }
        }
        throw new IllegalArgumentException("No CommentAction is associated with ID [" + id + "]");
    }

    public int getId() {
        return id;
    }
}
