package com.atlassian.bitbucket.build.status;

import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;

import javax.annotation.Nonnull;

/**
 * Manages build {@link RepositoryBuildStatus statuses}.
 *
 * @since 7.6
 */
public interface RepositoryBuildStatusService {

    /**
     * Search for build statuses that match the given request.
     *
     * @param request     the request containing the information to filter build statuses by
     * @param pageRequest the page request
     * @return a page of matching {@link RepositoryBuildStatus}
     */
    @Nonnull
    Page<RepositoryBuildStatus> search(@Nonnull BuildStatusRepositorySearchRequest request, @Nonnull PageRequest pageRequest);

    /**
     * Find build statuses for a pull request that match the given request.
     *
     * @param request     the request containing the information to filter build statuses by
     * @param pageRequest the page request
     * @return a page of matching {@link RepositoryBuildStatus}
     */
    @Nonnull
    Page<RepositoryBuildStatus> search(@Nonnull BuildStatusPullRequestSearchRequest request, @Nonnull PageRequest pageRequest);

    /**
     * Create a build status. If a build status with the same key already exists for the commit in the repository, this
     * will replace the existing one. It will replace all fields except for the {@link RepositoryBuildStatus#getCreatedDate()}.
     *
     * @param request the request containing the information to store
     */
    void set(@Nonnull RepositoryBuildStatusSetRequest request);
}
