package com.atlassian.bitbucket.build.status;

import com.atlassian.bitbucket.pull.PullRequest;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * A request to search for build statuses on a pull request
 *
 * @since 7.6
 */
public final class BuildStatusPullRequestSearchRequest extends AbstractBuildStatusSearchRequest {

    private final PullRequest pullRequest;

    private BuildStatusPullRequestSearchRequest(Builder builder) {
        super(builder);
        pullRequest = builder.pullRequest;
    }

    /**
     * Restrict the search to build statuses on this pull request.
     *
     * @return the pull request ID to search, or null to search across all pull requests
     */
    @Nonnull
    public PullRequest getPullRequest() {
        return pullRequest;
    }

    public static class Builder extends AbstractBuilder<Builder> {

        private final PullRequest pullRequest;

        public Builder(@Nonnull PullRequest pullRequest) {
            super(requireNonNull(pullRequest, "pullRequest").getToRef().getRepository());
            this.pullRequest = pullRequest;
        }

        public Builder(@Nonnull BuildStatusPullRequestSearchRequest request) {
            super(requireNonNull(request, "request"));
            pullRequest = request.getPullRequest();
        }

        @Nonnull
        @Override
        public BuildStatusPullRequestSearchRequest build() {
            return new BuildStatusPullRequestSearchRequest(this);
        }

        @Nonnull
        @Override
        public Builder self() {
            return this;
        }
    }
}
