package com.atlassian.bitbucket.build.status;

import javax.annotation.Nonnull;

/**
 * An abstraction describing a build server (e.g. Jenkins or Bamboo).
 *
 * @since 7.8
 */
public interface BuildServer {

    /**
     * Identifier that uniquely identifies this build server.
     *
     * @return an id that uniquely identifies this build server
     */
    @Nonnull
    String getId();

    /**
     * A human readable name for the build server, used to display to users in the UI.
     *
     * @return a human readable name for the build server
     */
    @Nonnull
    String getName();

    /**
     * Identifier of the type of the build server
     *
     * @return an id of the type of the build server
     */
    @Nonnull
    String getTypeId();
}
