package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * A specialisation of {@link AuthenticationException}, thrown when the underlying authentication subsystem fails
 * during authentication or an operation to update or query the authentication subsystem fails for some reason.
 * <p>
 * When thrown during authentication, this exception indicates that it could not be correctly attempted due to some
 * underlying system failure, rather than due to incorrect credentials or some abnormality with the user's account.
 * <p>
 * When thrown during updates or querying of authentication subsystems its meaning will be specific to the action and
 * context at the time and will be indicated in the exception's message.
 */
public class AuthenticationSystemException extends AuthenticationException {

    public AuthenticationSystemException(@Nonnull KeyedMessage message) {
        super(message);
    }

    public AuthenticationSystemException(@Nonnull KeyedMessage message, @Nullable Throwable cause) {
        super(message, cause);
    }
}
