package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.io.Serializable;
import java.util.Map;

/**
 * A context for accessing the currently-authenticated user.
 */
public interface AuthenticationContext {

    /**
     * @return the current user or {@code null} if anonymous
     */
    @Nullable
    ApplicationUser getCurrentUser();

    /**
     * @return the authentication properties provided during authentication; empty map if not authenticated
     * @since 5.5
     */
    @Nonnull
    Map<String, Serializable> getProperties();

    /**
     * @return {@code true} if the current request is authenticated
     */
    boolean isAuthenticated();
}
