package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

import static java.util.Optional.empty;

/**
 * The authentication details including the {@link ApplicationUser user} and any {@link #getProperties() properties}
 * provided during authentication.
 *
 * @since 5.5
 */
public interface Authentication {

    Authentication ANONYMOUS = new Authentication() {

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }

            if (obj instanceof Authentication) {
                Authentication that = (Authentication) obj;
                return that.getProperties().isEmpty() && !that.getUser().isPresent();
            }

            return false;
        }

        @Nonnull
        @Override
        public Map<String, Serializable> getProperties() {
            return Collections.emptyMap();
        }

        @Nonnull
        @Override
        public Optional<ApplicationUser> getUser() {
            return empty();
        }

        @Override
        public int hashCode() {
            return 0;
        }
    };

    /**
     * @return the authentication properties provided by the authenticator that authenticated the user. Can be empty,
     *          but never {@code null}.
     */
    @Nonnull
    Map<String, Serializable> getProperties();

    /**
     * @return The authenticated {@link ApplicationUser user}
     */
    @Nonnull
    Optional<ApplicationUser> getUser();
}
