package com.atlassian.bitbucket.audit;

import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.bitbucket.event.annotation.Auditable;

import javax.annotation.Nonnull;

/**
 * Converts an {@link Auditable} event into a {@link AuditEvent} (a representation suitable for auditing).
 *
 * Implementations <i>must</i> have a nullary (no argument) constructor and are intended to be <i>lightweight, stateless
 * classes</i>. Converters are instantiated for <i>each event</i> and discarded after the event has been converted.
 *
 * @param <T> the type of the original event
 * @see AuditEvent
 * @see Auditable
 * @since 7.0
 */
public interface AuditEventConverter<T> {

    /**
     * Converts an {@link Auditable} event into an {@link AuditEvent}.
     *
     * @param builder a builder for the auditing representation of the event, which may have some fields already set
     * @param event   the original annotated event
     * @return the details of the original event in a representation suitable for auditing
     */
    @Nonnull
    AuditEvent convert(@Nonnull T event, @Nonnull AuditEvent.Builder builder);
}
