package com.atlassian.bitbucket;

import com.atlassian.bitbucket.i18n.KeyedMessage;

public class NoSuchObjectException extends NoSuchEntityException {

    private final String object;
    
    public NoSuchObjectException(KeyedMessage keyedMessage, String object) {
        super(keyedMessage);
        this.object = object;
    }

    public NoSuchObjectException(KeyedMessage keyedMessage, String object, Throwable cause) {
        super(keyedMessage, cause);
        this.object = object;
    }

    public String getObject() {
        return object;
    }
}
