/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.pull.AbstractPullRequestRequest;
import com.atlassian.bitbucket.pull.PullRequest;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class PullRequestUpdateRequest
extends AbstractPullRequestRequest {
    private final String description;
    private final Set<String> reviewers;
    private final String title;
    private final String toBranchId;
    private final int version;

    private PullRequestUpdateRequest(Builder builder) {
        super(builder);
        this.description = builder.description;
        this.reviewers = builder.reviewers;
        this.title = builder.title;
        this.toBranchId = builder.toBranchId;
        this.version = builder.version;
        if (StringUtils.isBlank((CharSequence)this.title)) {
            throw new IllegalStateException("A \"title\" is required to update a pull request");
        }
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public Set<String> getReviewers() {
        return this.reviewers;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    @Nullable
    public String getToBranchId() {
        return this.toBranchId;
    }

    public int getVersion() {
        return this.version;
    }

    public static class Builder
    extends AbstractPullRequestRequest.AbstractBuilder<Builder> {
        private final int version;
        private String description;
        private ImmutableSet<String> reviewers;
        private String title;
        private String toBranchId;

        public Builder(@Nonnull PullRequest pullRequest, int version) {
            super(pullRequest);
            this.version = version;
            this.reviewers = ImmutableSet.of();
        }

        public Builder(int repositoryId, long pullRequestId, int version) {
            super(repositoryId, pullRequestId);
            this.version = version;
            this.reviewers = ImmutableSet.of();
        }

        @Nonnull
        public PullRequestUpdateRequest build() {
            return new PullRequestUpdateRequest(this);
        }

        @Nonnull
        public Builder description(@Nullable String value) {
            this.description = value;
            return this.self();
        }

        @Nonnull
        public Builder reviewers(@Nonnull Iterable<String> value) {
            this.reviewers = ImmutableSet.copyOf(Objects.requireNonNull(value, "reviewers"));
            return this.self();
        }

        @Nonnull
        public Builder title(@Nonnull String value) {
            this.title = Builder.checkNotBlank(value, "title");
            return this.self();
        }

        @Nonnull
        public Builder toBranchId(@Nullable String value) {
            this.toBranchId = value == null ? null : Builder.checkNotBlank(value, "toBranchId");
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

