/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.hook.repository.AbstractRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.PullRequestMergeHookRequest;
import com.atlassian.bitbucket.hook.repository.StandardRepositoryHookTrigger;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimplePullRequestMergeHookRequest
extends AbstractRepositoryHookRequest
implements PullRequestMergeHookRequest {
    private final String mergeHash;
    private final String message;
    private final PullRequest pullRequest;
    private final List<RefChange> refChanges;
    private final String strategyId;

    private SimplePullRequestMergeHookRequest(Builder builder) {
        super(builder);
        this.mergeHash = builder.mergeHash;
        this.message = builder.message;
        this.pullRequest = Objects.requireNonNull(builder.pullRequest, "pullRequest");
        this.strategyId = builder.strategyId;
        this.refChanges = this.mergeHash == null ? Collections.emptyList() : Collections.singletonList(((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)new SimpleRefChange.Builder().from(this.pullRequest.getToRef())).toHash(this.mergeHash)).type(RefChangeType.UPDATE)).build());
    }

    @Override
    @Nonnull
    public PullRequestRef getFromRef() {
        return this.pullRequest.getFromRef();
    }

    @Override
    @Nonnull
    public Optional<String> getMergeHash() {
        return Optional.ofNullable(this.mergeHash);
    }

    @Override
    @Nonnull
    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    @Override
    @Nonnull
    public PullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Override
    @Nonnull
    public Optional<String> getStrategyId() {
        return Optional.ofNullable(this.strategyId);
    }

    @Override
    @Nonnull
    public PullRequestRef getToRef() {
        return this.pullRequest.getToRef();
    }

    @Override
    @Nonnull
    public Collection<RefChange> getRefChanges() {
        return this.refChanges;
    }

    @Override
    public boolean isCrossRepository() {
        return this.pullRequest.isCrossRepository();
    }

    public static class Builder
    extends AbstractRepositoryHookRequest.AbstractBuilder<Builder> {
        private final PullRequest pullRequest;
        private String mergeHash;
        private String message;
        private String strategyId;

        public Builder(@Nonnull PullRequest pullRequest) {
            super(Objects.requireNonNull(pullRequest, "pullRequest").getToRef().getRepository(), StandardRepositoryHookTrigger.PULL_REQUEST_MERGE);
            this.pullRequest = pullRequest;
        }

        @Nonnull
        public SimplePullRequestMergeHookRequest build() {
            return new SimplePullRequestMergeHookRequest(this);
        }

        @Nonnull
        public Builder mergeHash(@Nullable String value) {
            this.mergeHash = value;
            return this.self();
        }

        @Nonnull
        public Builder message(@Nullable String value) {
            this.message = value;
            return this.self();
        }

        @Nonnull
        public Builder strategyId(@Nullable String value) {
            this.strategyId = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

