package com.atlassian.bitbucket.validation;

import com.atlassian.bitbucket.validation.annotation.RequiredUri;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.net.URI;

/**
 * Validates an object annotated with {@link RequiredUri}
 * @since 4.7
 */
public class RequiredUriValidator implements ConstraintValidator<RequiredUri, URI> {

    private int maxSize;

    @Override
    public void initialize(RequiredUri constraintAnnotation) {
        maxSize = constraintAnnotation.size();
    }

    @Override
    public boolean isValid(URI value, ConstraintValidatorContext context) {
        return value != null && value.toASCIIString().length() <= maxSize;
    }
}
