package com.atlassian.bitbucket.validation;

import javax.validation.ConstraintValidatorContext;

/**
 * Validate a value can be converted to an {@code Integer},
 * optionally validating whether the number is positive.
 */
public class IntegerValidator {

    protected boolean allowNegative;

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) { // null are considered valid to follow the JSR-303 conventions
            return true;     // ex: @Min, @Max, @Email, @SafeHtml, etc.
        } else {
            final Integer n = convert(value);
            return n != null && (allowNegative || n >= 0);
        }
    }

    private Integer convert(Object value) {
        if (value instanceof String) {
            try {
                return Integer.parseInt((String) value);
            } catch (NumberFormatException e) {
                // not a parseable int
            }
        } else if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
            return ((Number) value).intValue();
        } else if (value instanceof Long && ((Long) value) <= Integer.MAX_VALUE) {
            return ((Long) value).intValue();
        }

        return null;
    }

}
