package com.atlassian.bitbucket.validation;

import javax.annotation.Nonnull;
import java.util.Collection;
import java.util.Map;

/**
 * A container of field and one or more associated errors, to be displayed in a form.
 * <p>
 * Used by {@link FormValidationException}.
 */
public interface FormErrors {

    /**
     * @param field that potentially contains some errors
     * @return the error in question or an empty collection
     */
    @Nonnull
    Collection<String> getErrors(@Nonnull String field);

    /**
     * @return a map of fields to a collection of at least one associated error
     */
    @Nonnull
    Map<String, Collection<String>> getFieldErrors();

    /**
     * @return a collection of errors on the form (ie not attached to a field)
     */
    @Nonnull
    Collection<String> getFormErrors();

    /**
     * Indicates whether this instance of errors is empty, or has any errors.
     *
     * @return {@code true}, if this instance of {@code FormErrors} contains no errors of any type,
     * {@code false} otherwise
     */
    boolean isEmpty();
}
