package com.atlassian.bitbucket.user;

import javax.annotation.Nonnull;

/**
 * @see UserAdminService#createServiceUser(ServiceUserCreateRequest)
 */
public class ServiceUserCreateRequest extends AbstractServiceUserRequest {

    private ServiceUserCreateRequest(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder> {

        @Nonnull
        public ServiceUserCreateRequest build() {
            return new ServiceUserCreateRequest(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}
