package com.atlassian.bitbucket.user;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;

import java.util.Objects;

public class ApplicationUserEquality {

    public static boolean equals(ApplicationUser user, Object object) {
        if (user == object) {
            return true;
        }
        if (!(object instanceof ApplicationUser)) {
            return false;
        }

        if (user == null) {
            return false;
        }
        
        ApplicationUser other = (ApplicationUser) object;

        //IdentifierUtils.toLowerCase is null-safe, as is Objects.equals
        return Objects.equals(IdentifierUtils.toLowerCase(user.getName()),
                IdentifierUtils.toLowerCase(other.getName()));
    }
    
    public static int hashCode(ApplicationUser user) {
        //IdentifierUtils.toLowerCase is null-safe, as is Objects.hashCode
        return Objects.hashCode(IdentifierUtils.toLowerCase(user.getName()));
    }
}
