package com.atlassian.bitbucket.user;

import javax.annotation.Nonnull;

public abstract class AbstractVoidApplicationUserVisitor implements ApplicationUserVisitor<Void> {

    @Override
    public Void visit(@Nonnull DetailedUser user) {
        doVisit(user);
        return null;
    }

    @Override
    public Void visit(@Nonnull ServiceUser user) {
        doVisit(user);
        return null;
    }

    @Override
    public Void visit(@Nonnull ApplicationUser user) {
        doVisit(user);
        return null;
    }

    protected void doVisit(@Nonnull DetailedUser user) {
    }

    protected void doVisit(@Nonnull ServiceUser user) {
    }

    protected void doVisit(@Nonnull ApplicationUser user) {
    }

}
