package com.atlassian.bitbucket.server;

/**
 * Enumerates possible operating systems.
 * <p>
 * Operating systems are classified loosely. For example, individual versions of macOS and Windows are not considered
 * distinct, and Linux distributions are not differentiated.
 * <p>
 * If the system is started on an <i>unsupported operating system</i>, like FreeBSD or Solaris, the operating system
 * will be reported as {@link #LINUX}.
 *
 * @since 6.2
 */
public enum OperatingSystem {

    /**
     * Linux-based operating systems.
     * <p>
     * <b>Note</b>: Any operating system that isn't {@link #MAC_OS macOS} or {@link #WINDOWS Windows} or Linux,
     * like FreeBSD or Solaris, will be reported as Linux.
     */
    LINUX,
    /**
     * Mac-based operating systems.
     */
    MAC_OS,
    /**
     * Windows-based operating systems.
     */
    WINDOWS
}
