package com.atlassian.bitbucket.server;

import com.atlassian.bitbucket.FeatureDisabledException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

/**
 * Indicates the current operation cannot be processed because it is incompatible with the
 * {@link com.atlassian.bitbucket.server.ApplicationMode application mode}
 *
 * @since 4.1
 */
public class IncompatibleApplicationModeException extends FeatureDisabledException {

    public IncompatibleApplicationModeException(@Nonnull KeyedMessage message) {
        super(message);
    }
}
