package com.atlassian.bitbucket.server;

/**
 * Enumerates database types.
 *
 * @since 7.9
 */
public enum DatabaseType {
    /**
     * H2 internal database
     */
    H2,
    /**
     * Maria DB database
     */
    MARIADB,
    /**
     * MySql database
     */
    MYSQL,
    /**
     * Oracle database
     */
    ORACLE,
    /**
     * Postgres database
     */
    POSTGRES,
    /**
     * Microsoft's SQL Server database
     */
    SQLSERVER,
    /**
     * If the database type is unable to be determined, or is unsupported this type is used
     */
    UNKNOWN
}
